/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.panel;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.ShiftRegisterParameter;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.panel.BlockParameterPanel;
import DE.siemens.ad.logo.util.Language;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ShiftRegisterPanel
extends BlockParameterPanel {
    private JComboBox fShiftRegisterOutput;
    private JComboBox fShiftRegisterIndex;
    private JLabel fShiftRegisterLabel;
    private JLabel fShiftRegisterIndexLable;

    public ShiftRegisterPanel(Vector panels, Parameter parameterReference, boolean simulation) {
        super(panels, parameterReference, simulation);
        JPanel shiftRegisterPanel = new JPanel();
        shiftRegisterPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 100.0;
        this.fShiftRegisterIndexLable = new JLabel("Shift register index");
        shiftRegisterPanel.add((Component)this.fShiftRegisterIndexLable, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.fShiftRegisterLabel = new JLabel("Shfit register for output");
        shiftRegisterPanel.add((Component)this.fShiftRegisterLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 10.0;
        this.fShiftRegisterIndex = new JComboBox();
        shiftRegisterPanel.add((Component)this.fShiftRegisterIndex, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        this.fShiftRegisterOutput = new JComboBox();
        shiftRegisterPanel.add((Component)this.fShiftRegisterOutput, gbc);
        this.addParameterPane(shiftRegisterPanel);
    }

    public void loadFieldContents() {
        super.loadFieldContents();
        ShiftRegisterParameter shiftRegisterParameter = (ShiftRegisterParameter)this.fParameterReference;
        WiringDiagram wiringDiagram = shiftRegisterParameter.getBlock().getWiringDiagram();
        Hardware hardware = wiringDiagram.getHardware();
        int maxShiftRegisterInputNumbers = hardware.getMaxResource(19) / hardware.getMaxResource(18);
        Integer selectedItem = null;
        DefaultComboBoxModel<Integer> comboBoxModel = new DefaultComboBoxModel<Integer>();
        for (int i = 0; i < maxShiftRegisterInputNumbers; ++i) {
            Integer currentShiftRegisterOutput = new Integer(i + 1);
            comboBoxModel.addElement(currentShiftRegisterOutput);
            if (i != shiftRegisterParameter.getOutputBit()) continue;
            selectedItem = currentShiftRegisterOutput;
        }
        this.fShiftRegisterOutput.setModel(comboBoxModel);
        if (selectedItem != null) {
            this.fShiftRegisterOutput.setSelectedItem(selectedItem);
        }
        Block block = ((BlockParameter)this.fParameterReference).getBlock();
        int[] freeInputNumbers = block.getWiringDiagram().getFreeNumbers(18);
        int curIndex = shiftRegisterParameter.getIndex();
        int insertPosition = -1;
        if (freeInputNumbers.length > 0) {
            for (int i = 0; i < freeInputNumbers.length; ++i) {
                if (insertPosition < 0 && curIndex < freeInputNumbers[i]) {
                    this.fShiftRegisterIndex.addItem(new Integer(curIndex + 1));
                    insertPosition = i;
                }
                this.fShiftRegisterIndex.addItem(new Integer(freeInputNumbers[i]));
            }
            if (curIndex >= freeInputNumbers[freeInputNumbers.length - 1]) {
                this.fShiftRegisterIndex.addItem(new Integer(curIndex + 1));
                insertPosition = freeInputNumbers.length;
            }
        } else {
            this.fShiftRegisterIndex.addItem(new Integer(curIndex + 1));
            insertPosition = 0;
        }
        this.fShiftRegisterIndex.setSelectedIndex(insertPosition);
        if (hardware.getMaxResource(18) <= 1) {
            this.fShiftRegisterIndexLable.setVisible(false);
            this.fShiftRegisterIndex.setVisible(false);
        }
    }

    public void storeFieldContents() {
        super.storeFieldContents();
        ShiftRegisterParameter shiftRegisterParameter = (ShiftRegisterParameter)this.fParameterReference;
        int bitNumber = (Integer)this.fShiftRegisterOutput.getSelectedItem() - 1;
        shiftRegisterParameter.setOutputBit(bitNumber);
        if (this.fShiftRegisterIndex.isVisible()) {
            int index = (Integer)this.fShiftRegisterIndex.getSelectedItem() - 1;
            shiftRegisterParameter.setIndex(index, true);
        }
    }

    public boolean checkChanged() {
        boolean changed = super.checkChanged();
        ShiftRegisterParameter shiftRegisterParameter = (ShiftRegisterParameter)this.fParameterReference;
        changed = changed || !new Integer(shiftRegisterParameter.getOutputBit() + 1).equals(this.fShiftRegisterOutput.getSelectedItem());
        changed = changed || !new Integer(shiftRegisterParameter.getIndex() + 1).equals(this.fShiftRegisterIndex.getSelectedItem());
        return changed;
    }

    public boolean checkFieldContents() {
        return this.fShiftRegisterOutput.getSelectedItem() != null && this.fShiftRegisterIndex.getSelectedItem() != null;
    }

    public void setLabels() {
        super.setLabels();
        this.fShiftRegisterLabel.setText(Language.getString("dialog.parameter.shiftRegister.outputBit", "Bit for output"));
        this.fShiftRegisterIndexLable.setText(Language.getString("dialog.parameter.shiftRegister.index", "Index"));
    }
}

